<?php
require 'db.php';
require 'auth.php';
require_login();
require_admin();

$message = '';
$messageType = '';

// Handle simple delete all for testing
if (isset($_POST['simple_delete_all'])) {
    try {
        // Count records before delete
        $countBefore = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
        echo "<p>Records before delete: $countBefore</p>";
        
        // Delete all data from peminjaman table
        $deletedCount = $db->exec("DELETE FROM peminjaman");
        
        // Count records after delete
        $countAfter = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
        
        echo "<p>Deleted count: $deletedCount</p>";
        echo "<p>Records after delete: $countAfter</p>";
        
        $message = "SUCCESS: $deletedCount records deleted!";
        $messageType = 'success';
        
    } catch (Exception $e) {
        $message = "Error: " . $e->getMessage();
        $messageType = 'danger';
    }
}

// Get current data count
$currentCount = 0;
try {
    $currentCount = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
} catch (Exception $e) {
    echo "Error getting count: " . $e->getMessage();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Simple Delete Test</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        <h2>Simple Delete All Test</h2>
        
        <?php if ($message): ?>
        <div class="alert alert-<?= $messageType ?>">
            <?= $message ?>
        </div>
        <?php endif; ?>
        
        <div class="card">
            <div class="card-body">
                <h5>Current Records: <?= $currentCount ?></h5>
                
                <?php if ($currentCount > 0): ?>
                <form method="POST" style="margin-top: 20px;">
                    <button type="submit" name="simple_delete_all" class="btn btn-danger" onclick="return confirm('Delete all <?= $currentCount ?> records?')">
                        Delete All Records
                    </button>
                </form>
                <?php else: ?>
                <p class="text-muted">No records to delete</p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="mt-3">
            <a href="backup-restore.php" class="btn btn-secondary">Back to Backup Restore</a>
            <a href="index.php" class="btn btn-primary">Back to Main</a>
        </div>
        
        <div class="mt-4">
            <h4>Sample Records:</h4>
            <?php
            try {
                $rows = $db->query("SELECT id, nomor_perkara, nama, status FROM peminjaman LIMIT 10")->fetchAll();
                if ($rows) {
                    echo "<table class='table table-sm'>";
                    echo "<tr><th>ID</th><th>Nomor Perkara</th><th>Nama</th><th>Status</th></tr>";
                    foreach ($rows as $row) {
                        echo "<tr><td>{$row['id']}</td><td>{$row['nomor_perkara']}</td><td>{$row['nama']}</td><td>{$row['status']}</td></tr>";
                    }
                    echo "</table>";
                } else {
                    echo "<p>No records found</p>";
                }
            } catch (Exception $e) {
                echo "Error: " . $e->getMessage();
            }
            ?>
        </div>
    </div>
</body>
</html>
