<?php
require 'db.php';
require 'auth.php';
require_login();
require_admin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ketua_nama = trim($_POST['ketua_nama'] ?? '');
    $wakil_nama = trim($_POST['wakil_nama'] ?? '');
    $panitera_nama = trim($_POST['panitera_nama'] ?? '');
    $panmud_nama = trim($_POST['panmud_nama'] ?? '');
    
    // Validate required fields
    if (empty($ketua_nama) || empty($wakil_nama) || empty($panitera_nama) || empty($panmud_nama)) {
        header('Location: admin.php?error=Semua field harus diisi');
        exit;
    }
    
    try {
        // Save settings
        setting_set('ketua_nama', $ketua_nama);
        setting_set('wakil_nama', $wakil_nama);
        setting_set('panitera_nama', $panitera_nama);
        setting_set('panmud_nama', $panmud_nama);
        
        header('Location: admin.php?success=1');
    } catch (Exception $e) {
        header('Location: admin.php?error=Gagal menyimpan: ' . $e->getMessage());
    }
} else {
    header('Location: admin.php');
}
exit;
?>
