# Use Case Diagram - Sistem Peminjaman Berkas PN Watampone

## Deskripsi
Use Case Diagram ini menggambarkan interaksi antara aktor (Admin dan Petugas) dengan sistem peminjaman berkas Pengadilan Negeri Watampone.

## Aktor
1. **Admin** - Memiliki akses penuh ke semua fitur sistem
2. **Petugas** - Memiliki akses terbatas untuk operasional harian

## Use Cases

### 📋 **MANAJEMEN AUTENTIKASI**
- Login ke Sistem
- Logout dari Sistem  
- Ganti Password

### 📁 **MANAJEMEN PEMINJAMAN BERKAS**
- Tambah Data Peminjaman Baru
- Lihat Data Peminjaman
- Edit Data Peminjaman (Admin Only)
- Hapus Data Peminjaman (Admin Only)
- Cari Data Peminjaman
- Filter Data Peminjaman

### 🔄 **OPERASIONAL PEMINJAMAN**
- Perpanjang Peminjaman
- Proses Pengembalian Berkas
- Monitor Status Peminjaman

### 🖨️ **SISTEM CETAK & DOKUMENTASI**
- Cetak Surat Peminjaman
- Cetak Bukti Pengembalian
- Generate QR Code Verifikasi

### 🔍 **MANAJEMEN ARSIP**
- Akses Arsip Online (SIPP)
- Akses Arsip Lokal (SQLite)
- Autocomplete Nomor Perkara
- Sinkronisasi Data Arsip
- Import Data CSV

### 📊 **LAPORAN & NOTIFIKASI**
- Lihat Laporan Peminjaman
- Lihat Notifikasi Keterlambatan
- Generate Statistik

### ⚙️ **ADMINISTRASI SISTEM (Admin Only)**
- Kelola Pengaturan Pejabat
- Manajemen User Account
- Backup Database
- Restore Database
- Hapus Semua Data
- Monitor Status Sistem

## Diagram Visual (PlantUML Format)

```plantuml
@startuml
!theme plain
title Use Case Diagram - Sistem Peminjaman Berkas PN Watampone

left to right direction

actor "Petugas" as Petugas
actor "Admin" as Admin

rectangle "Sistem Peminjaman Berkas" {
  
  package "Autentikasi" {
    usecase "Login ke Sistem" as UC1
    usecase "Logout dari Sistem" as UC2
    usecase "Ganti Password" as UC3
  }
  
  package "Manajemen Peminjaman" {
    usecase "Tambah Data Peminjaman" as UC4
    usecase "Lihat Data Peminjaman" as UC5
    usecase "Edit Data Peminjaman" as UC6
    usecase "Hapus Data Peminjaman" as UC7
    usecase "Cari Data Peminjaman" as UC8
    usecase "Filter Data Peminjaman" as UC9
  }
  
  package "Operasional Peminjaman" {
    usecase "Perpanjang Peminjaman" as UC10
    usecase "Proses Pengembalian" as UC11
    usecase "Monitor Status" as UC12
  }
  
  package "Cetak & Dokumentasi" {
    usecase "Cetak Surat Peminjaman" as UC13
    usecase "Cetak Bukti Pengembalian" as UC14
    usecase "Generate QR Code" as UC15
  }
  
  package "Manajemen Arsip" {
    usecase "Akses Arsip Online" as UC16
    usecase "Akses Arsip Lokal" as UC17
    usecase "Autocomplete Nomor Perkara" as UC18
    usecase "Sinkronisasi Data" as UC19
    usecase "Import Data CSV" as UC20
  }
  
  package "Laporan & Notifikasi" {
    usecase "Lihat Laporan" as UC21
    usecase "Lihat Notifikasi" as UC22
    usecase "Generate Statistik" as UC23
  }
  
  package "Administrasi Sistem" {
    usecase "Kelola Pengaturan Pejabat" as UC24
    usecase "Manajemen User" as UC25
    usecase "Backup Database" as UC26
    usecase "Restore Database" as UC27
    usecase "Hapus Semua Data" as UC28
    usecase "Monitor Status Sistem" as UC29
  }
}

' External System
actor "Database SIPP" as SIPP

' Petugas Connections
Petugas --> UC1
Petugas --> UC2
Petugas --> UC3
Petugas --> UC4
Petugas --> UC5
Petugas --> UC8
Petugas --> UC9
Petugas --> UC10
Petugas --> UC11
Petugas --> UC12
Petugas --> UC13
Petugas --> UC14
Petugas --> UC15
Petugas --> UC16
Petugas --> UC17
Petugas --> UC18
Petugas --> UC19
Petugas --> UC20
Petugas --> UC21
Petugas --> UC22
Petugas --> UC23

' Admin Connections (Inherits all from Petugas + Admin-only features)
Admin --> UC1
Admin --> UC2
Admin --> UC3
Admin --> UC4
Admin --> UC5
Admin --> UC6
Admin --> UC7
Admin --> UC8
Admin --> UC9
Admin --> UC10
Admin --> UC11
Admin --> UC12
Admin --> UC13
Admin --> UC14
Admin --> UC15
Admin --> UC16
Admin --> UC17
Admin --> UC18
Admin --> UC19
Admin --> UC20
Admin --> UC21
Admin --> UC22
Admin --> UC23
Admin --> UC24
Admin --> UC25
Admin --> UC26
Admin --> UC27
Admin --> UC28
Admin --> UC29

' System Dependencies
UC16 --> SIPP : <<access>>
UC18 --> SIPP : <<access>>
UC19 --> SIPP : <<sync>>

' Include Relationships
UC14 ..> UC15 : <<include>>
UC4 ..> UC18 : <<include>>
UC19 ..> UC16 : <<include>>
UC19 ..> UC17 : <<include>>

' Extend Relationships
UC6 ..> UC5 : <<extend>>
UC7 ..> UC5 : <<extend>>
UC10 ..> UC5 : <<extend>>
UC11 ..> UC5 : <<extend>>

note right of Admin
  Admin memiliki akses
  ke semua fitur sistem
  termasuk manajemen
  user dan backup
end note

note right of Petugas
  Petugas memiliki akses
  terbatas untuk operasional
  harian peminjaman berkas
end note

note bottom of SIPP
  Database SIPP eksternal
  di server 192.168.1.240
  untuk data arsip perkara
end note

@enduml
```

## Deskripsi Use Cases

### 🔐 **Autentikasi**
- **UC1-UC3**: Sistem login/logout dengan role-based access control

### 📋 **Manajemen Peminjaman**
- **UC4**: Form tambah peminjaman dengan autocomplete nomor perkara
- **UC5**: Dashboard tabel data dengan search dan filter
- **UC6-UC7**: Edit/hapus data (admin only)
- **UC8-UC9**: Pencarian dan filter data real-time

### 🔄 **Operasional**
- **UC10**: Perpanjangan dengan tracking counter
- **UC11**: Pengembalian dengan timestamp
- **UC12**: Monitor status dipinjam/dikembalikan

### 🖨️ **Dokumentasi**
- **UC13**: Surat peminjaman format resmi
- **UC14**: Bukti pengembalian dengan QR code
- **UC15**: QR code untuk verifikasi

### 📁 **Arsip**
- **UC16-UC17**: Akses database SIPP online dan SQLite lokal
- **UC18**: Autocomplete dari data arsip
- **UC19**: Sinkronisasi SIPP ke SQLite
- **UC20**: Import alternatif via CSV

### 📊 **Laporan**
- **UC21**: Laporan dengan filter periode
- **UC22**: Notifikasi keterlambatan
- **UC23**: Statistik dashboard

### ⚙️ **Administrasi**
- **UC24**: Pengaturan nama pejabat
- **UC25**: CRUD user accounts
- **UC26-UC28**: Backup, restore, delete database
- **UC29**: Monitor status sistem

## Relationships

### **Include**
- Cetak Bukti → Generate QR Code
- Tambah Data → Autocomplete
- Sinkronisasi → Akses Arsip

### **Extend** 
- Edit/Hapus → dari Lihat Data
- Perpanjang/Kembalikan → dari Lihat Data

### **Dependency**
- Sistem → Database SIPP (eksternal)

## Constraint & Business Rules

1. **Role Constraint**: Hanya Admin yang bisa edit/hapus data
2. **Security**: Semua akses memerlukan autentikasi
3. **Data Integrity**: Validasi form client & server side
4. **External Dependency**: Fitur arsip bergantung koneksi SIPP
5. **Backup Safety**: Auto backup sebelum operasi berbahaya
