<?php
echo "<h1>🎉 APLIKASI PEMINJAMAN BERKAS - FULL RECOVERY COMPLETE</h1>";
echo "<p><em>Semua file telah berhasil di-restore dan dikembalikan!</em></p>";

echo "<div style='background:#d1ecf1;padding:15px;border:1px solid #bee5eb;border-radius:5px;margin:20px 0;'>";
echo "<h3>✅ SEMUA FILE TELAH DIKEMBALIKAN</h3>";

$core_files = [
    'db.php' => 'Database dengan timezone WITA',
    'auth.php' => 'Sistem autentikasi',
    'login.php' => 'Halaman login dengan UI modern',
    'logout.php' => 'Proses logout',
    'index.php' => 'Dashboard utama dengan semua fitur',
    'save.php' => 'Simpan peminjaman baru',
    'update.php' => 'Edit peminjaman (admin only)',
    'delete.php' => 'Hapus peminjaman (admin only)',
    'return.php' => 'Proses pengembalian berkas',
    'extend.php' => 'Perpanjangan peminjaman',
    'print.php' => 'Cetak surat peminjaman',
    'bukti.php' => 'Cetak bukti pengembalian dengan QR',
    'admin.php' => 'Pengaturan pejabat',
    'settings_save.php' => 'Simpan pengaturan admin'
];

echo "<h4>📁 Core Files:</h4>";
foreach ($core_files as $file => $desc) {
    $exists = file_exists($file);
    $size = $exists ? filesize($file) : 0;
    $status = $exists && $size > 0 ? '✅' : '❌';
    echo "<p>$status <strong>$file</strong> - $desc</p>";
}

echo "<h4>📁 Admin Files:</h4>";
$admin_files = [
    'admin/users.php' => 'Manajemen akun pengguna',
    'admin/user_store.php' => 'Tambah akun baru',
    'admin/user_update.php' => 'Edit akun',
    'admin/user_delete.php' => 'Hapus akun'
];

foreach ($admin_files as $file => $desc) {
    $exists = file_exists($file);
    $size = $exists ? filesize($file) : 0;
    $status = $exists && $size > 0 ? '✅' : '❌';
    echo "<p>$status <strong>$file</strong> - $desc</p>";
}

echo "</div>";

echo "<div style='background:#f8d7da;padding:15px;border:1px solid #f5c6cb;border-radius:5px;margin:20px 0;'>";
echo "<h3>🚀 FITUR-FITUR YANG SUDAH DIPULIHKAN</h3>";
echo "<ul>";
echo "<li>✅ <strong>Authentication System</strong> - Login/logout dengan role admin & petugas</li>";
echo "<li>✅ <strong>Dashboard Utama</strong> - Tabel data dengan search, filter, sorting</li>";
echo "<li>✅ <strong>CRUD Operations</strong> - Create, Read, Update, Delete (admin only untuk edit/delete)</li>";
echo "<li>✅ <strong>Perpanjangan</strong> - Extend peminjaman dengan konfirmasi popup</li>";
echo "<li>✅ <strong>Pengembalian</strong> - Return berkas dengan tracking waktu</li>";
echo "<li>✅ <strong>Print System</strong> - Cetak surat peminjaman dan bukti pengembalian</li>";
echo "<li>✅ <strong>QR Code</strong> - Bukti pengembalian dengan QR code berisi waktu</li>";
echo "<li>✅ <strong>Role-based Access</strong> - Pembatasan akses berdasarkan role</li>";
echo "<li>✅ <strong>Responsive UI</strong> - Bootstrap 5.3.3 dengan Font Awesome</li>";
echo "<li>✅ <strong>Timezone WITA</strong> - Waktu Indonesia Tengah untuk Watampone</li>";
echo "<li>✅ <strong>Admin Settings</strong> - Pengaturan nama pejabat</li>";
echo "<li>✅ <strong>User Management</strong> - Kelola akun admin dan petugas</li>";
echo "</ul>";
echo "</div>";

echo "<div style='background:#fff3cd;padding:15px;border:1px solid #ffeaa7;border-radius:5px;margin:20px 0;'>";
echo "<h3>🔐 DEFAULT LOGIN</h3>";
echo "<p><strong>Username:</strong> <code>admin</code></p>";
echo "<p><strong>Password:</strong> <code>admin123</code></p>";
echo "<p><strong>Role:</strong> Administrator (akses penuh)</p>";
echo "</div>";

echo "<div style='background:#d4edda;padding:15px;border:1px solid #c3e6cb;border-radius:5px;margin:20px 0;'>";
echo "<h3>🎯 QUICK ACCESS</h3>";
echo "<div style='display:flex;gap:10px;flex-wrap:wrap;'>";
echo "<a href='login.php' style='padding:10px 15px;background:#007bff;color:white;text-decoration:none;border-radius:5px;'>🔐 Login</a>";
echo "<a href='index.php' style='padding:10px 15px;background:#28a745;color:white;text-decoration:none;border-radius:5px;'>🏠 Dashboard</a>";
echo "<a href='admin.php' style='padding:10px 15px;background:#17a2b8;color:white;text-decoration:none;border-radius:5px;'>⚙️ Settings</a>";
echo "<a href='admin/users.php' style='padding:10px 15px;background:#ffc107;color:black;text-decoration:none;border-radius:5px;'>👥 Users</a>";
echo "<a href='test-timezone.php' style='padding:10px 15px;background:#6f42c1;color:white;text-decoration:none;border-radius:5px;'>🕐 Timezone</a>";
echo "</div>";
echo "</div>";

// Database check
echo "<h3>💾 DATABASE STATUS</h3>";
try {
    require 'db.php';
    echo "<p style='color:green'>✅ Database connection: <strong>OK</strong></p>";
    echo "<p>🕐 Timezone: <strong>" . date_default_timezone_get() . "</strong> (Current: " . date('Y-m-d H:i:s') . " WITA)</p>";
    
    $users_count = $db->query('SELECT COUNT(*) FROM users')->fetchColumn();
    $peminjaman_count = $db->query('SELECT COUNT(*) FROM peminjaman')->fetchColumn();
    $kembali_count = $db->query("SELECT COUNT(*) FROM peminjaman WHERE status='kembali'")->fetchColumn();
    
    echo "<p>👥 Users: <strong>$users_count</strong> accounts</p>";
    echo "<p>📚 Total Peminjaman: <strong>$peminjaman_count</strong> records</p>";
    echo "<p>✅ Sudah Dikembalikan: <strong>$kembali_count</strong> records</p>";
    
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Database error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h2 style='text-align:center;color:#28a745;'>🎊 RECOVERY COMPLETED SUCCESSFULLY! 🎊</h2>";
echo "<p style='text-align:center;'><em>Aplikasi Peminjaman Berkas siap digunakan dengan semua fitur lengkap!</em></p>";
echo "<p style='text-align:center;font-size:12px;color:#666;'>Recovery completed at: " . date('Y-m-d H:i:s') . " WITA</p>";
?>
