<?php
/**
 * Check PHP Error Log - untuk melihat debug messages
 */

echo "<h3>PHP Error Log Viewer</h3>";

// Cek lokasi error log
$log_file = ini_get('error_log');
if (!$log_file) {
    $log_file = 'C:/xampp/apache/logs/error.log'; // Default XAMPP location
}

echo "<p><strong>Log file:</strong> <code>$log_file</code></p>";

if (file_exists($log_file)) {
    echo "<p><strong>File size:</strong> " . number_format(filesize($log_file)) . " bytes</p>";
    
    // Ambil 50 baris terakhir
    $lines = file($log_file);
    $total_lines = count($lines);
    $start = max(0, $total_lines - 50);
    
    echo "<h4>Last 50 lines:</h4>";
    echo "<div style='background: #f8f9fa; padding: 10px; border: 1px solid #dee2e6; max-height: 400px; overflow-y: auto;'>";
    echo "<pre>";
    
    for ($i = $start; $i < $total_lines; $i++) {
        $line = htmlspecialchars($lines[$i]);
        if (strpos($line, 'SYNC DEBUG') !== false) {
            echo "<span style='background: yellow;'>$line</span>";
        } else {
            echo $line;
        }
    }
    
    echo "</pre>";
    echo "</div>";
    
} else {
    echo "<p style='color: red;'>Error log file tidak ditemukan!</p>";
    echo "<p>Possible locations:</p>";
    echo "<ul>";
    echo "<li>C:/xampp/apache/logs/error.log</li>";
    echo "<li>C:/xampp/php/logs/php_error_log</li>";
    echo "<li>" . sys_get_temp_dir() . "/php_errors.log</li>";
    echo "</ul>";
}

echo "<hr>";
echo "<p><a href='sync-sipp-to-sqlite.php'>← Back to Sync</a> | <a href='debug-sync.php'>Debug Sync</a></p>";
?>
