<?php
/**
 * SIPP Connection Status API - untuk AJAX check
 */

header('Content-Type: application/json');

// Konfigurasi database SIPP (sama dengan sync)
$sipp_config = [
    'host' => '192.168.1.240',
    'dbname' => 'sippbaco',
    'username' => 'pnwtp',
    'password' => 'pnwtp2019',
    'port' => 3306
];

$response = [
    'success' => false,
    'message' => '',
    'details' => []
];

try {
    // Test koneksi dengan metode yang sama seperti arsip.php dan sync (setelah fix)
    $dsn = "mysql:host={$sipp_config['host']};port={$sipp_config['port']};dbname={$sipp_config['dbname']};charset=utf8mb4";
    $pdo = new PDO($dsn, $sipp_config['username'], $sipp_config['password']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Test query sederhana
    $stmt = $pdo->query("SELECT COUNT(*) FROM arsip");
    $count = $stmt->fetchColumn();
    
    $response['success'] = true;
    $response['message'] = 'Connection successful';
    $response['details'] = [
        'host' => $sipp_config['host'],
        'database' => $sipp_config['dbname'],
        'record_count' => number_format($count),
        'status' => 'Connected'
    ];
    
} catch (PDOException $e) {
    $response['success'] = false;
    $response['message'] = 'Connection failed: ' . $e->getMessage();
    $response['details'] = [
        'host' => $sipp_config['host'],
        'database' => $sipp_config['dbname'],
        'error' => $e->getMessage(),
        'status' => 'Disconnected'
    ];
}

echo json_encode($response);
?>
