<?php
echo "<h1>📋 TEST FITUR BUKTI PENGEMBALIAN & PERPANJANGAN</h1>";
echo "<p><em>Testing fitur yang diambil dari peminjaman-berkas-full-merged-bukti</em></p>";

echo "<div style='background:#d1ecf1;padding:15px;border:1px solid #bee5eb;border-radius:5px;margin:20px 0;'>";
echo "<h3>✅ FITUR BUKTI & PERPANJANGAN TERBARU</h3>";
echo "<p>✅ <strong>Bukti Pengembalian:</strong> Format sederhana dengan QR code</p>";
echo "<p>✅ <strong>Perpanjangan Disabled:</strong> Tombol perpanjang dimatikan setelah dikembalikan</p>";
echo "<p>✅ <strong>Tanda Tangan Lengkap:</strong> Ketua/Wakil, Panitera, Panmud, Pemohon</p>";
echo "<p>✅ <strong>QR Code Verifikasi:</strong> Berisi info ID, nomor perkara, tanggal, petugas</p>";
echo "<p>✅ <strong>Auto Print:</strong> Langsung muncul dialog cetak</p>";
echo "</div>";

require 'db.php';

try {
    // Get sample data with different status
    $stmt = $db->query("SELECT * FROM peminjaman ORDER BY status DESC, id DESC LIMIT 10");
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h3>📋 TEST DATA PEMINJAMAN:</h3>";
    echo "<table border='1' style='border-collapse:collapse;width:100%;'>";
    echo "<tr style='background:#f8f9fa;'>";
    echo "<th style='padding:8px;'>ID</th>";
    echo "<th style='padding:8px;'>Nama</th>";
    echo "<th style='padding:8px;'>Nomor Perkara</th>";
    echo "<th style='padding:8px;'>Status</th>";
    echo "<th style='padding:8px;'>Perpanjangan</th>";
    echo "<th style='padding:8px;'>Action</th>";
    echo "</tr>";
    
    foreach ($data as $row) {
        echo "<tr>";
        echo "<td style='padding:8px;text-align:center;'>{$row['id']}</td>";
        echo "<td style='padding:8px;'>" . htmlspecialchars($row['nama']) . "</td>";
        echo "<td style='padding:8px;'>" . htmlspecialchars($row['nomor_perkara']) . "</td>";
        echo "<td style='padding:8px;text-align:center;'>";
        if ($row['status'] === 'dipinjam') {
            echo "<span style='background:#ffc107;padding:2px 8px;border-radius:3px;'>DIPINJAM</span>";
        } else {
            echo "<span style='background:#28a745;padding:2px 8px;border-radius:3px;color:white;'>KEMBALI</span>";
        }
        echo "</td>";
        echo "<td style='padding:8px;text-align:center;'>";
        echo "<span style='background:#17a2b8;color:white;padding:2px 8px;border-radius:3px;'>{$row['perpanjangan_count']} kali</span>";
        echo "</td>";
        echo "<td style='padding:8px;text-align:center;'>";
        
        if ($row['status'] === 'dipinjam') {
            // Berkas masih dipinjam - perpanjangan aktif
            echo "<button style='background:#6c757d;color:white;padding:5px 10px;border:none;border-radius:3px;margin-right:5px;'>📅 Perpanjang</button>";
            echo "<button style='background:#28a745;color:white;padding:5px 10px;border:none;border-radius:3px;'>✅ Kembalikan</button>";
        } else {
            // Berkas sudah dikembalikan - perpanjangan disabled
            echo "<button style='background:#e9ecef;color:#6c757d;padding:5px 10px;border:none;border-radius:3px;margin-right:5px;cursor:not-allowed;' disabled>📅 Perpanjang</button>";
            echo "<a href='bukti.php?id={$row['id']}' target='_blank' style='background:#007bff;color:white;padding:5px 10px;text-decoration:none;border-radius:3px;'>📋 Bukti</a>";
        }
        
        echo "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<div style='background:#fff3cd;padding:15px;border:1px solid #ffeaa7;border-radius:5px;margin:20px 0;'>";
echo "<h3>📝 PERUBAHAN FITUR BUKTI & PERPANJANGAN:</h3>";
echo "<h4>🔄 SEBELUM:</h4>";
echo "<ul>";
echo "<li>❌ Perpanjangan bisa dilakukan setelah dikembalikan</li>";
echo "<li>❌ Bukti pengembalian tidak ada QR code</li>";
echo "<li>❌ Layout bukti terlalu kompleks</li>";
echo "</ul>";

echo "<h4>✅ SEKARANG (dari full-merged-bukti):</h4>";
echo "<ul>";
echo "<li>✅ <strong>Perpanjangan Disabled:</strong> Tombol perpanjang dimatikan setelah berkas dikembalikan</li>";
echo "<li>✅ <strong>Bukti Pengembalian:</strong> Format sederhana dan profesional</li>";
echo "<li>✅ <strong>QR Code Verifikasi:</strong> Berisi info lengkap untuk verifikasi</li>";
echo "<li>✅ <strong>Tanda Tangan 4 Pihak:</strong> Ketua/Wakil, Panitera, Panmud, Pemohon</li>";
echo "<li>✅ <strong>Auto Print:</strong> Langsung print saat dibuka</li>";
echo "</ul>";
echo "</div>";

echo "<div style='background:#d4edda;padding:15px;border:1px solid #c3e6cb;border-radius:5px;margin:20px 0;'>";
echo "<h3>🎯 QUICK ACCESS</h3>";
echo "<div style='display:flex;gap:10px;flex-wrap:wrap;'>";
echo "<a href='index.php' style='padding:10px 15px;background:#28a745;color:white;text-decoration:none;border-radius:5px;'>🏠 Dashboard</a>";
echo "<a href='bukti.php?id=1' target='_blank' style='padding:10px 15px;background:#007bff;color:white;text-decoration:none;border-radius:5px;'>📋 Test Bukti ID 1</a>";
echo "<a href='test-print-new.php' style='padding:10px 15px;background:#17a2b8;color:white;text-decoration:none;border-radius:5px;'>🖨️ Test Print</a>";
echo "<a href='recovery-complete.php' style='padding:10px 15px;background:#6f42c1;color:white;text-decoration:none;border-radius:5px;'>📋 Recovery Status</a>";
echo "</div>";
echo "</div>";

echo "<div style='background:#f8d7da;padding:15px;border:1px solid #f5c6cb;border-radius:5px;margin:20px 0;'>";
echo "<h3>🔧 CARA TEST FITUR:</h3>";
echo "<ol>";
echo "<li><strong>Test Perpanjangan Disabled:</strong> Lihat tabel di atas - berkas yang sudah dikembalikan tombol perpanjang disabled</li>";
echo "<li><strong>Test Bukti Pengembalian:</strong> Klik 'Test Bukti ID 1' untuk melihat format bukti baru</li>";
echo "<li><strong>Lihat QR Code:</strong> QR code berisi info ID, nomor perkara, tanggal kembali, dan petugas</li>";
echo "<li><strong>Check Auto Print:</strong> Bukti akan langsung muncul dialog print</li>";
echo "<li><strong>Verifikasi Tanda Tangan:</strong> 4 tanda tangan (Ketua/Wakil, Panitera, Panmud, Pemohon)</li>";
echo "</ol>";
echo "</div>";

echo "<div style='background:#e2e3e5;padding:15px;border:1px solid #d6d8db;border-radius:5px;margin:20px 0;'>";
echo "<h3>📋 LOGIKA PERPANJANGAN:</h3>";
echo "<div style='display:grid;grid-template-columns:1fr 1fr;gap:20px;'>";

echo "<div>";
echo "<h4 style='color:#28a745;'>✅ JIKA STATUS = 'dipinjam'</h4>";
echo "<ul>";
echo "<li>Tombol perpanjang AKTIF ✅</li>";
echo "<li>Tombol kembalikan AKTIF ✅</li>";
echo "<li>Bukti pengembalian TIDAK TERSEDIA ❌</li>";
echo "</ul>";
echo "</div>";

echo "<div>";
echo "<h4 style='color:#dc3545;'>❌ JIKA STATUS = 'kembali'</h4>";
echo "<ul>";
echo "<li>Tombol perpanjang DISABLED ❌</li>";
echo "<li>Tombol kembalikan TIDAK ADA ❌</li>";
echo "<li>Bukti pengembalian TERSEDIA ✅</li>";
echo "</ul>";
echo "</div>";

echo "</div>";
echo "</div>";

echo "<hr>";
echo "<h2 style='text-align:center;color:#007bff;'>📋 FITUR BUKTI & PERPANJANGAN BERHASIL DIPERBAHARUI! 📋</h2>";
echo "<p style='text-align:center;'><em>Sekarang perpanjangan otomatis disabled setelah dikembalikan dan bukti pengembalian lebih sederhana</em></p>";
echo "<p style='text-align:center;font-size:12px;color:#666;'>Updated at: " . date('Y-m-d H:i:s') . " WITA</p>";
?>
