<?php
require 'db.php';
require 'auth.php';
require_login();
require_admin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ketua_nama = trim($_POST['ketua_nama'] ?? '');
    $wakil_nama = trim($_POST['wakil_nama'] ?? '');
    $plh_nama = trim($_POST['plh_nama'] ?? '');
    $panitera_nama = trim($_POST['panitera_nama'] ?? '');
    $plh_panitera_nama = trim($_POST['plh_panitera_nama'] ?? '');
    $panitera_aktif = trim($_POST['panitera_aktif'] ?? 'panitera');
    $panmud_nama = trim($_POST['panmud_nama'] ?? '');
    $plh_panmud_nama = trim($_POST['plh_panmud_nama'] ?? '');
    $panmud_aktif = trim($_POST['panmud_aktif'] ?? 'panmud');
    
    // Validate required fields
    if (empty($ketua_nama) || empty($wakil_nama) || empty($panitera_nama) || empty($panmud_nama)) {
        header('Location: admin.php?error=Semua field harus diisi');
        exit;
    }
    
    try {
        // Save settings
        setting_set('ketua_nama', $ketua_nama);
        setting_set('wakil_nama', $wakil_nama);
        setting_set('plh_nama', $plh_nama);
        setting_set('panitera_nama', $panitera_nama);
        setting_set('plh_panitera_nama', $plh_panitera_nama);
        setting_set('panitera_aktif', $panitera_aktif);
        setting_set('panmud_nama', $panmud_nama);
        setting_set('plh_panmud_nama', $plh_panmud_nama);
        setting_set('panmud_aktif', $panmud_aktif);
        
        header('Location: admin.php?success=1');
    } catch (Exception $e) {
        header('Location: admin.php?error=Gagal menyimpan: ' . $e->getMessage());
    }
} else {
    header('Location: admin.php');
}
exit;
?>
