<?php require 'auth.php'; require 'db.php';
$id = intval($_GET['id'] ?? 0);
$format = intval($_GET['format'] ?? 1); // Default format 1

$stmt = $db->prepare("SELECT * FROM peminjaman WHERE id=?");
$stmt->execute([$id]); $row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row){ http_response_code(404); echo "Data tidak ditemukan"; exit; }

// Get pejabat names from settings
$ketua = setting_get('ketua_nama', 'H. Abdul Rahman, S.H., M.H.');
$wakil = setting_get('wakil_nama', 'Drs. Muhammad Saleh, S.H.');
$plh = setting_get('plh_nama', '');
$panitera_nama = setting_get('panitera_nama', 'Hj. Siti Nurhaliza, S.H.');
$plh_panitera_nama = setting_get('plh_panitera_nama', '');
$panitera_aktif = setting_get('panitera_aktif', 'panitera');
$panmud_nama = setting_get('panmud_nama', 'Ahmad Fauzi, S.H.');
$plh_panmud_nama = setting_get('plh_panmud_nama', '');
$panmud_aktif = setting_get('panmud_aktif', 'panmud');

// Determine which panitera and panmud to use
$panitera = ($panitera_aktif === 'plh_panitera') ? $plh_panitera_nama : $panitera_nama;
$jabatan_panitera = ($panitera_aktif === 'plh_panitera') ? 'PLH Panitera' : 'Panitera';
$panmud = ($panmud_aktif === 'plh_panmud') ? $plh_panmud_nama : $panmud_nama;
$jabatan_panmud = ($panmud_aktif === 'plh_panmud') ? 'PLH Panmud Hukum' : 'Panmud Hukum';

// Determine signer based on database choice
$penandatangan_pilihan = $row['penandatangan'] ?? 'ketua';
if ($penandatangan_pilihan === 'wakil') {
    $jabatan_penandatangan = 'Wakil Ketua Pengadilan Negeri Watampone';
    $nama_penandatangan = $wakil;
} elseif ($penandatangan_pilihan === 'plh') {
    $jabatan_penandatangan = 'PLH Ketua Pengadilan Negeri Watampone';
    $nama_penandatangan = $plh;
} else {
    $jabatan_penandatangan = 'Ketua Pengadilan Negeri Watampone';
    $nama_penandatangan = $ketua;
}

function esc($s){ return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8'); }
?>
<!doctype html>
<html lang="id"><head>
<meta charset="utf-8"><title>Cetak - Format <?= $format ?></title>
<style>
*{box-sizing:border-box}
body{font-family:'Times New Roman',serif;font-size:12pt;margin:0;background:#fff}
@page{size:A4;margin:2cm}
.page{width:100%;min-height:calc(297mm - 4cm);page-break-after:always}
.center{text-align:center} table{width:100%;border-collapse:collapse} td{padding:4px 0;vertical-align:top}
.ttd{height:90px}.kop{margin-bottom:6px}.kop h3,.kop h4{margin:0 0 4px 0}.muted{font-size:10pt}
<?php if($format == 2): ?>
/* Format 2 - Ringkas */
.ttd{height:60px}
body{font-size:11pt}
.compact-table td{padding:2px 0}
<?php endif; ?>
</style>
</head>
<body>

<?php if($format == 1): ?>
<!-- FORMAT 1: Standar dengan Kop Lengkap -->
<div class="page">
  <div class="center kop">
    <img src="gambar/kop_surat.png" style="max-width:700px;width:100%;height:auto"><br>
    <h3><strong>TANDA TERIMA PINJAM PAKAI BERKAS PERKARA</strong></h3>
    <h4><strong>KEPANITERAAN HUKUM</strong></h4>
  </div>
  <table>
    <tr><td style="width:220px">Nama</td><td>: <?= esc($row['nama']) ?></td></tr>
    <tr><td>Jabatan</td><td>: <?= esc($row['jabatan']) ?></td></tr>
    <tr><td>Kepentingan</td><td>: <?= esc($row['tujuan']) ?></td></tr>
    <tr><td>Nomor Perkara</td><td>: <?= esc($row['nomor_perkara']) ?></td></tr>
    <tr><td>Nama Pihak</td><td>: <?= esc($row['nama_pihak']) ?><?php if(!empty($row['nama_pihak_lain'])): ?> ✖ <?= esc($row['nama_pihak_lain']) ?><?php endif; ?></td></tr>
    <?php if(!empty($row['jenis_keterangan'])): ?><tr><td>Jenis Keterangan</td><td>: <?= esc($row['jenis_keterangan']) ?></td></tr><?php endif; ?>
    <tr><td>Tanggal Pengambilan</td><td>: <?= esc($row['tanggal_ambil']) ?></td></tr>
    <tr><td>Tanggal Pengembalian</td><td>: <?= esc($row['tanggal_kembali']) ?></td></tr>
    <tr><td>Jumlah Perpanjangan</td><td>: <?= (int)$row['perpanjangan_count'] ?> kali</td></tr>
  </table>
  
  <div style="margin-top:15px; margin-bottom:15px;">
    <strong>Keterangan :</strong><br>
    Batas waktu peminjaman berkas 3 (tiga) hari<br>
    Demikian permohonan ini, Atas kejasamanya kami ucapkan terima kasih.
  </div>
  
  <div style="text-align:right; margin-bottom:20px;">
    Watampone, <?= !empty($row['tanggal_tanda_tangan']) ? date('d-m-Y', strtotime($row['tanggal_tanda_tangan'])) : date('d-m-Y') ?>
  </div>
  
  <div class="center" style="margin-bottom:20px;">Pemohon<div class="ttd"></div><strong>(<?= esc($row['nama']) ?>)</strong></div>
  
  <table>
    <tr>
      <td class="center">Mengetahui<br><?= esc($jabatan_penandatangan) ?><div class="ttd"></div><strong><?= esc($nama_penandatangan) ?></strong></td>
      <td class="center">Disetujui<br><?= esc($jabatan_panitera) ?><div class="ttd"></div><strong><?= esc($panitera) ?></strong></td>
      <td class="center">Diperiksa<br><?= esc($jabatan_panmud) ?><div class="ttd"></div><strong><?= esc($panmud) ?></strong></td>
    </tr>
  </table>
</div>

<div class="page" style="page-break-after:auto">
  <div class="center kop">
    <img src="gambar/kop_surat.png" style="max-width:700px;width:100%;height:auto"><br>
    <h3><strong>FORMULIR PEMINJAMAN BERKAS</strong></h3>
    <h4><strong>KEPANITERAAN HUKUM</strong></h4>
  </div>
  <table>
    <tr><td style="width:220px">Nama</td><td>: <?= esc($row['nama']) ?></td></tr>
    <tr><td>Jabatan</td><td>: <?= esc($row['jabatan']) ?></td></tr>
    <tr><td>Tujuan Peminjaman</td><td>: <?= esc($row['tujuan']) ?></td></tr>
    <tr><td>Nomor Perkara</td><td>: <?= esc($row['nomor_perkara']) ?></td></tr>
    <tr><td>Nama Pihak</td><td>: <?= esc($row['nama_pihak']) ?><?php if(!empty($row['nama_pihak_lain'])): ?> ✖ <?= esc($row['nama_pihak_lain']) ?><?php endif; ?></td></tr>
  </table>
  <br><br><br>
  <table style="width:100%;">
    <tr>
      <td style="width:20%;"></td>
      <td style="width:80%; text-align:left; padding-left:9cm;">
        Watampone, <?= !empty($row['tanggal_tanda_tangan']) ? date('d-m-Y', strtotime($row['tanggal_tanda_tangan'])) : date('d-m-Y') ?><br>
        Peminjam<div class="ttd"></div><strong>(<?= esc($row['nama']) ?>)</strong>
      </td>
    </tr>
  </table>
</div>

<?php else: ?>
<!-- FORMAT 2: Sama seperti Format 1 tanpa Keterangan dan Perpanjangan -->
<div class="page">
  <div class="center kop">
    <img src="gambar/kop_surat.png" style="max-width:700px;width:100%;height:auto"><br>
    <h3><strong>TANDA TERIMA PINJAM PAKAI BERKAS PERKARA</strong></h3>
    <h4><strong>KEPANITERAAN HUKUM</strong></h4>
  </div>
  <table>
    <tr><td style="width:220px">Nama</td><td>: <?= esc($row['nama']) ?></td></tr>
    <tr><td>Jabatan</td><td>: <?= esc($row['jabatan']) ?></td></tr>
    <tr><td>Kepentingan</td><td>: <?= esc($row['tujuan']) ?></td></tr>
    <tr><td>Nomor Perkara</td><td>: <?= esc($row['nomor_perkara']) ?></td></tr>
    <tr><td>Nama Pihak</td><td>: <?= esc($row['nama_pihak']) ?><?php if(!empty($row['nama_pihak_lain'])): ?> ✖ <?= esc($row['nama_pihak_lain']) ?><?php endif; ?></td></tr>
    <?php if(!empty($row['jenis_keterangan'])): ?><tr><td>Jenis Keterangan</td><td>: <?= esc($row['jenis_keterangan']) ?></td></tr><?php endif; ?>
    <tr><td>Tanggal Pengambilan</td><td>: <?= esc($row['tanggal_ambil']) ?></td></tr>
    <tr><td>Tanggal Pengembalian</td><td>: </td></tr>
  </table>
  
  <div style="margin-top:60px;"></div>
  
  <div style="text-align:right; margin-bottom:20px;">
    Watampone, <?= !empty($row['tanggal_tanda_tangan']) ? date('d-m-Y', strtotime($row['tanggal_tanda_tangan'])) : date('d-m-Y') ?>
  </div>
  
  <div class="center" style="margin-bottom:20px;">Pemohon<div class="ttd"></div><strong>(<?= esc($row['nama']) ?>)</strong></div>
  
  <table>
    <tr>
      <td class="center">Mengetahui<br><?= esc($jabatan_penandatangan) ?><div class="ttd"></div><strong><?= esc($nama_penandatangan) ?></strong></td>
      <td class="center">Disetujui<br><?= esc($jabatan_panitera) ?><div class="ttd"></div><strong><?= esc($panitera) ?></strong></td>
      <td class="center">Diperiksa<br><?= esc($jabatan_panmud) ?><div class="ttd"></div><strong><?= esc($panmud) ?></strong></td>
    </tr>
  </table>
</div>

<div class="page" style="page-break-after:auto">
  <div class="center kop">
    <img src="gambar/kop_surat.png" style="max-width:700px;width:100%;height:auto"><br>
    <h3><strong>FORMULIR PEMINJAMAN BERKAS</strong></h3>
    <h4><strong>KEPANITERAAN HUKUM</strong></h4>
  </div>
  <table>
    <tr><td style="width:220px">Nama</td><td>: <?= esc($row['nama']) ?></td></tr>
    <tr><td>Jabatan</td><td>: <?= esc($row['jabatan']) ?></td></tr>
    <tr><td>Tujuan Peminjaman</td><td>: <?= esc($row['tujuan']) ?></td></tr>
    <tr><td>Nomor Perkara</td><td>: <?= esc($row['nomor_perkara']) ?></td></tr>
    <tr><td>Nama Pihak</td><td>: <?= esc($row['nama_pihak']) ?><?php if(!empty($row['nama_pihak_lain'])): ?> ✖ <?= esc($row['nama_pihak_lain']) ?><?php endif; ?></td></tr>
  </table>
  <br><br><br>
  <table style="width:100%;">
    <tr>
      <td style="width:20%;"></td>
      <td style="width:80%; text-align:left; padding-left:9cm;">
        Watampone, <?= !empty($row['tanggal_tanda_tangan']) ? date('d-m-Y', strtotime($row['tanggal_tanda_tangan'])) : date('d-m-Y') ?><br>
        Peminjam<div class="ttd"></div><strong>(<?= esc($row['nama']) ?>)</strong>
      </td>
    </tr>
  </table>
</div>
<?php endif; ?>

<script>window.onload=function(){window.print();}</script>
</body></html>
