<?php
require 'db.php';
require 'auth.php';
require_login();

// Check user permissions
$user = current_user();
$isAdmin = $user['role'] === 'admin';
$isPetugas = $user['role'] === 'petugas';

if (!$isAdmin && !$isPetugas) {
  header('Location: index.php?error=Akses ditolak');
  exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = (int)($_POST['id'] ?? 0);
  $nama = trim($_POST['nama'] ?? '');
  $jabatan = trim($_POST['jabatan'] ?? '');
  $tujuan = trim($_POST['tujuan'] ?? '');
  $nomor_perkara = trim($_POST['nomor_perkara'] ?? '');
  $nama_pihak = trim($_POST['nama_pihak'] ?? '');
  $nama_pihak_lain = trim($_POST['nama_pihak_lain'] ?? '');
  $tanggal_ambil = $_POST['tanggal_ambil'] ?? '';
  $lama = (int)($_POST['lama'] ?? 3);
  $penandatangan = $_POST['penandatangan'] ?? '';
  $tanggal_tanda_tangan = $_POST['tanggal_tanda_tangan'] ?? null;
  if (empty($tanggal_tanda_tangan)) $tanggal_tanda_tangan = null;
  
  // Validate required fields
  if ($id <= 0 || empty($nama) || empty($jabatan) || empty($tujuan) || 
      empty($nomor_perkara) || empty($nama_pihak) || empty($tanggal_ambil) || 
      empty($penandatangan)) {
    header('Location: index.php?error=Semua field wajib harus diisi');
    exit;
  }
  
  // Calculate return date
  $ta = new DateTime($tanggal_ambil);
  $ta->add(new DateInterval('P'.$lama.'D'));
  $tanggal_kembali = $ta->format('Y-m-d');
  
  try {
    // Check if record exists and is still 'dipinjam'
    $check = $db->prepare("SELECT status, edit_count FROM peminjaman WHERE id = ?");
    $check->execute([$id]);
    $current = $check->fetch(PDO::FETCH_ASSOC);
    
    if (!$current) {
      header('Location: index.php?error=Data tidak ditemukan');
      exit;
    }
    
    if ($current['status'] !== 'dipinjam') {
      header('Location: index.php?error=Hanya data dengan status dipinjam yang bisa diedit');
      exit;
    }
    
    // Check edit limit for petugas
    if ($isPetugas) {
      $currentEditCount = (int)($current['edit_count'] ?? 0);
      if ($currentEditCount >= 1) {
        header('Location: index.php?error=Anda sudah menggunakan 1 kali kesempatan edit');
        exit;
      }
    }
    
    // Prepare SQL based on user role
    if ($isPetugas) {
      // Increment edit_count for petugas
      $stmt = $db->prepare("UPDATE peminjaman SET 
        nama = ?, jabatan = ?, tujuan = ?, nomor_perkara = ?, nama_pihak = ?, 
        nama_pihak_lain = ?, tanggal_ambil = ?, tanggal_kembali = ?, penandatangan = ?,
        tanggal_tanda_tangan = ?, edit_count = edit_count + 1
        WHERE id = ?");
    } else {
      // Admin doesn't affect edit_count
      $stmt = $db->prepare("UPDATE peminjaman SET 
        nama = ?, jabatan = ?, tujuan = ?, nomor_perkara = ?, nama_pihak = ?, 
        nama_pihak_lain = ?, tanggal_ambil = ?, tanggal_kembali = ?, penandatangan = ?,
        tanggal_tanda_tangan = ?
        WHERE id = ?");
    }
    
    $result = $stmt->execute([
      $nama, $jabatan, $tujuan, $nomor_perkara, $nama_pihak, 
      $nama_pihak_lain, $tanggal_ambil, $tanggal_kembali, $penandatangan, $tanggal_tanda_tangan, $id
    ]);
    
    if ($result) {
      if ($isPetugas) {
        header('Location: index.php?success=updated&warning=Anda telah menggunakan 1 kali kesempatan edit');
      } else {
        header('Location: index.php?success=updated');
      }
    } else {
      header('Location: index.php?error=Gagal mengupdate data');
    }
  } catch (PDOException $e) {
    header('Location: index.php?error=Error: ' . $e->getMessage());
  }
} else {
  header('Location: index.php');
}
exit;
?>
