<?php
// Simple test to check file operations in backups directory
$backupDir = __DIR__ . DIRECTORY_SEPARATOR . 'backups';

echo "<h1>Backup Directory Test</h1>";
echo "Backup directory: $backupDir<br>";
echo "Directory exists: " . (is_dir($backupDir) ? 'YES' : 'NO') . "<br>";
echo "Directory writable: " . (is_writable($backupDir) ? 'YES' : 'NO') . "<br>";

if (is_dir($backupDir)) {
    echo "<h2>Files in backup directory:</h2>";
    $files = scandir($backupDir);
    foreach ($files as $file) {
        if ($file !== '.' && $file !== '..') {
            $filepath = $backupDir . DIRECTORY_SEPARATOR . $file;
            if (is_file($filepath)) {
                echo "- $file (size: " . filesize($filepath) . " bytes, writable: " . (is_writable($filepath) ? 'YES' : 'NO') . ")<br>";
            }
        }
    }
}

// Test creating and deleting a temporary file
echo "<h2>Permission Test:</h2>";
$testFile = $backupDir . DIRECTORY_SEPARATOR . 'test_file.txt';
if (file_put_contents($testFile, 'test content')) {
    echo "✅ Can create file<br>";
    if (unlink($testFile)) {
        echo "✅ Can delete file<br>";
    } else {
        echo "❌ Cannot delete file<br>";
    }
} else {
    echo "❌ Cannot create file<br>";
}
?>
