<?php
require_once 'config/config.php';
require_once 'includes/functions.php';

// Require login
$auth->requireLogin();

$page_title = 'Riwayat Izin';
$current_user = $auth->getCurrentUser();

// Get filters
$status_filter = $_GET['status'] ?? '';
$type_filter = $_GET['type'] ?? '';
$page = max(1, intval($_GET['page'] ?? 1));

// Build filters array
$filters = [];
if ($status_filter) $filters['status'] = $status_filter;
if ($type_filter) $filters['permission_type_id'] = $type_filter;

// Get permissions
$result = $permissionManager->getPermissionsByUser($current_user['id'], $page, 10, $filters);
$permissions = $result['success'] ? $result['data'] : [];
$total_pages = $result['success'] ? $result['total_pages'] : 1;

// Get permission types for filter
$permission_types = $permissionManager->getPermissionTypes();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - SISKIM PN Watampone</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <style>
        .sidebar { transition: all 0.3s; }
        .nav-item.active { background-color: #1e3a8a; color: white; }
        .nav-item.active svg { color: white; }
    </style>
</head>
<body class="bg-gray-50">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <?php include 'includes/sidebar.php'; ?>

        <!-- Main Content -->
        <div class="flex-1 overflow-auto">
            <!-- Header -->
            <?php include 'includes/header.php'; ?>

            <!-- Content -->
            <main class="p-6">
                <!-- Breadcrumb -->
                <?php 
                generateBreadcrumb([
                    ['title' => 'Dashboard', 'url' => 'dashboard.php', 'icon' => 'home'],
                    ['title' => 'Riwayat Izin', 'url' => '']
                ]); 
                ?>
                
                <!-- Flash Messages -->
                <?php showFlashMessage(); ?>
                
                <div class="mb-6 flex justify-between items-center">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800">Riwayat Pengajuan Izin</h1>
                        <p class="text-gray-600 mt-1">Daftar semua pengajuan izin Anda</p>
                    </div>
                    <a href="pengajuan.php" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 flex items-center">
                        <i data-feather="plus" class="w-4 h-4 mr-2"></i>
                        Ajukan Izin Baru
                    </a>
                </div>

                <!-- Filters -->
                <div class="bg-white rounded-lg shadow p-6 mb-6">
                    <h3 class="text-lg font-semibold mb-4">Filter Pencarian</h3>
                    <form method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <select name="status" class="block w-full border border-gray-300 rounded-lg py-2 px-3">
                                <option value="">Semua Status</option>
                                <option value="pending" <?php echo ($status_filter === 'pending') ? 'selected' : ''; ?>>Menunggu</option>
                                <option value="approved" <?php echo ($status_filter === 'approved') ? 'selected' : ''; ?>>Disetujui</option>
                                <option value="rejected" <?php echo ($status_filter === 'rejected') ? 'selected' : ''; ?>>Ditolak</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Jenis Izin</label>
                            <select name="type" class="block w-full border border-gray-300 rounded-lg py-2 px-3">
                                <option value="">Semua Jenis</option>
                                <?php foreach ($permission_types as $type): ?>
                                <option value="<?php echo $type['id']; ?>" <?php echo ($type_filter == $type['id']) ? 'selected' : ''; ?>>
                                    <?php echo escape($type['name']); ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="flex items-end">
                            <button type="submit" class="w-full bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 flex items-center justify-center">
                                <i data-feather="filter" class="w-4 h-4 mr-2"></i>
                                Filter
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Data Table -->
                <div class="bg-white rounded-lg shadow overflow-hidden">
                    <div class="overflow-x-auto">
                        <?php if (!empty($permissions)): ?>
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jenis Izin</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Waktu</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Keperluan</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php foreach ($permissions as $permission): ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <?php echo formatTanggalIndonesia($permission['request_date']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo escape($permission['permission_type_name']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <?php echo formatWaktu($permission['start_time']) . ' - ' . formatWaktu($permission['end_time']); ?>
                                        <br>
                                        <span class="text-xs text-gray-400">
                                            (<?php echo hitungDurasi($permission['start_time'], $permission['end_time']); ?>)
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-900 max-w-xs">
                                        <div class="truncate" title="<?php echo escape($permission['purpose']); ?>">
                                            <?php echo escape(substr($permission['purpose'], 0, 50)) . (strlen($permission['purpose']) > 50 ? '...' : ''); ?>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php echo getStatusBadge($permission['status']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                        <a href="detail.php?id=<?php echo $permission['id']; ?>" class="text-blue-600 hover:text-blue-900">
                                            <i data-feather="eye" class="w-4 h-4 inline"></i> Detail
                                        </a>
                                        <?php if ($permission['status'] === 'pending'): ?>
                                        <button onclick="deletePermission(<?php echo $permission['id']; ?>)" class="text-red-600 hover:text-red-900 ml-2">
                                            <i data-feather="trash-2" class="w-4 h-4 inline"></i> Hapus
                                        </button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        
                        <!-- Pagination -->
                        <?php echo generatePagination($page, $total_pages, 'riwayat.php'); ?>
                        
                        <?php else: ?>
                        <div class="p-12 text-center">
                            <i data-feather="inbox" class="w-16 h-16 mx-auto text-gray-300 mb-4"></i>
                            <h3 class="text-lg font-medium text-gray-900 mb-2">Belum ada riwayat izin</h3>
                            <p class="text-gray-500 mb-6">Anda belum pernah mengajukan izin.</p>
                            <a href="pengajuan.php" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700">
                                <i data-feather="plus" class="w-4 h-4 mr-2"></i>
                                Ajukan Izin Pertama
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div id="deleteModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3 text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                    <i data-feather="trash-2" class="h-6 w-6 text-red-600"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900 mt-2">Hapus Pengajuan</h3>
                <div class="mt-2 px-7 py-3">
                    <p class="text-sm text-gray-500">Apakah Anda yakin ingin menghapus pengajuan izin ini? Tindakan ini tidak dapat dibatalkan.</p>
                </div>
                <div class="items-center px-4 py-3">
                    <button id="confirmDelete" class="px-4 py-2 bg-red-500 text-white text-base font-medium rounded-md w-24 mr-2 hover:bg-red-600">
                        Hapus
                    </button>
                    <button onclick="closeDeleteModal()" class="px-4 py-2 bg-gray-300 text-gray-800 text-base font-medium rounded-md w-24 hover:bg-gray-400">
                        Batal
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        feather.replace();
        
        let deleteId = null;
        
        function deletePermission(id) {
            deleteId = id;
            document.getElementById('deleteModal').classList.remove('hidden');
        }
        
        function closeDeleteModal() {
            deleteId = null;
            document.getElementById('deleteModal').classList.add('hidden');
        }
        
        document.getElementById('confirmDelete').addEventListener('click', function() {
            if (deleteId) {
                window.location.href = 'delete_permission.php?id=' + deleteId;
            }
        });
        
        // Mobile menu toggle
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('hidden');
        }
    </script>
</body>
</html>