<?php
/**
 * Sidebar Component
 * SISKIM - Sistem Izin Keluar Masuk
 */

$current_user = $auth->getCurrentUser();
$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<div class="sidebar bg-white w-64 shadow-lg hidden md:block">
    <div class="p-4 border-b border-gray-200">
        <div class="flex items-center space-x-2">
            <?php echo getLogoHtml('w-10 h-10 rounded'); ?>
            <div>
                <h2 class="text-xl font-bold text-gray-800">SISKIM</h2>
                <p class="text-xs text-gray-500">PN Watampone</p>
            </div>
        </div>
    </div>
    <nav class="p-4">
        <div class="mb-6">
            <p class="text-xs uppercase text-gray-500 font-semibold mb-2">Menu Utama</p>
            <ul class="space-y-1">
                <li>
                    <a href="dashboard.php" class="nav-item <?php echo ($current_page == 'dashboard') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg">
                        <i data-feather="home" class="w-5 h-5 text-gray-500"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                <li>
                    <a href="pengajuan.php" class="nav-item <?php echo ($current_page == 'pengajuan') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="file-text" class="w-5 h-5 text-gray-500"></i>
                        <span>Pengajuan Izin</span>
                    </a>
                </li>
                <?php if ($current_user['role'] === 'admin'): ?>
                <li>
                    <a href="persetujuan.php" class="nav-item <?php echo ($current_page == 'persetujuan') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="check-circle" class="w-5 h-5 text-gray-500"></i>
                        <span>Persetujuan</span>
                    </a>
                </li>
                <?php endif; ?>
                <li>
                    <a href="riwayat.php" class="nav-item <?php echo ($current_page == 'riwayat') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="clock" class="w-5 h-5 text-gray-500"></i>
                        <span>Riwayat Izin</span>
                    </a>
                </li>
                <li>
                    <a href="kalender.php" class="nav-item <?php echo ($current_page == 'kalender') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="calendar" class="w-5 h-5 text-gray-500"></i>
                        <span>Kalender Izin</span>
                    </a>
                </li>
                <?php if ($current_user['role'] === 'admin'): ?>
                <li>
                    <a href="laporan.php" class="nav-item <?php echo ($current_page == 'laporan') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="bar-chart-2" class="w-5 h-5 text-gray-500"></i>
                        <span>Laporan</span>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
        <div>
            <p class="text-xs uppercase text-gray-500 font-semibold mb-2">Pengaturan</p>
            <ul class="space-y-1">
                <li>
                    <a href="profile.php" class="nav-item <?php echo ($current_page == 'profile') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="user" class="w-5 h-5 text-gray-500"></i>
                        <span>Profil</span>
                    </a>
                </li>
                <li>
                    <a href="gallery.php" class="nav-item <?php echo ($current_page == 'gallery') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="image" class="w-5 h-5 text-gray-500"></i>
                        <span>Galeri</span>
                    </a>
                </li>
                <?php if ($current_user['role'] === 'admin'): ?>
                <li>
                    <a href="settings.php" class="nav-item <?php echo ($current_page == 'settings') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="settings" class="w-5 h-5 text-gray-500"></i>
                        <span>Pengaturan</span>
                    </a>
                </li>
                <li>
                    <a href="users.php" class="nav-item <?php echo ($current_page == 'users') ? 'active' : ''; ?> flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="users" class="w-5 h-5 text-gray-500"></i>
                        <span>Pengguna</span>
                    </a>
                </li>
                <?php endif; ?>
                <li>
                    <a href="logout.php" class="nav-item flex items-center space-x-2 p-2 rounded-lg hover:bg-gray-100">
                        <i data-feather="log-out" class="w-5 h-5 text-gray-500"></i>
                        <span>Keluar</span>
                    </a>
                </li>
            </ul>
        </div>
    </nav>
</div>

<style>
.nav-item.active {
    background-color: #1e3a8a;
    color: white;
}
.nav-item.active svg {
    color: white;
}
</style>