<?php
/**
 * Image Handler untuk SISKIM
 * File untuk menangani permintaan gambar
 */

// Daftar gambar yang diizinkan
$allowed_images = [
    'Logo_pnwtp.png',
    'kop_surat.png', 
    'gedung-pn-wtp.png'
];

// Ambil parameter gambar
$image = $_GET['img'] ?? '';

// Validasi input
if (empty($image) || !in_array($image, $allowed_images)) {
    http_response_code(404);
    exit('Image not found');
}

// Path ke file gambar
$image_path = __DIR__ . '/gambar/' . $image;

// Cek apakah file exists
if (!file_exists($image_path)) {
    http_response_code(404);
    exit('Image file not found');
}

// Tentukan content type berdasarkan ekstensi
$ext = strtolower(pathinfo($image, PATHINFO_EXTENSION));
$content_types = [
    'jpg' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'png' => 'image/png',
    'gif' => 'image/gif',
    'svg' => 'image/svg+xml'
];

$content_type = $content_types[$ext] ?? 'image/png';

// Set headers untuk caching (1 bulan)
header('Content-Type: ' . $content_type);
header('Cache-Control: public, max-age=2592000');
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 2592000) . ' GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s', filemtime($image_path)) . ' GMT');
header('Content-Length: ' . filesize($image_path));

// Output file
readfile($image_path);
exit();
?>