# SISKIM - Sistem Izin Keluar Masuk
## Pengadilan Negeri Watampone

Aplikasi web untuk mengelola pengajuan izin keluar masuk pegawai di lingkungan Pengadilan Negeri Watampone.

### Fitur Utama

- **Sistem Autentikasi**: Login/logout dengan NIP dan password
- **Dashboard**: Statistik dan ringkasan pengajuan izin
- **Pengajuan Izin**: Form pengajuan dengan berbagai jenis izin
- **Riwayat Izin**: Daftar semua pengajuan dengan filter
- **Persetujuan**: Sistem approval untuk admin/atasan
- **Database SQLite**: Penyimpanan data yang mudah dan portable

### Teknologi yang Digunakan

- **Backend**: PHP 7.4+
- **Database**: SQLite
- **Frontend**: HTML5, CSS3, JavaScript, Tailwind CSS
- **Icons**: Feather Icons
- **Web Server**: Apache dengan mod_rewrite

### Persyaratan Sistem

- PHP 7.4 atau lebih baru
- Web server (Apache/Nginx)
- Extension PHP: PDO, PDO_SQLite
- XAMPP/WAMP/LAMP (untuk development)

### Instalasi

1. **Persiapan Web Server**
   ```bash
   # Untuk XAMPP di Windows
   - Download dan install XAMPP dari https://www.apachefriends.org/
   - Start Apache service dari XAMPP Control Panel
   ```

2. **Clone/Download Project**
   ```bash
   # Clone atau extract file ke folder htdocs XAMPP
   cd C:\xampp\htdocs
   # Project sudah ada di folder 'ijinkeluar'
   ```

3. **Set Permissions (Linux/Mac)**
   ```bash
   chmod 755 ijinkeluar/
   chmod 777 ijinkeluar/database/
   chmod 777 ijinkeluar/uploads/
   ```

4. **Akses Aplikasi**
   - Buka browser dan kunjungi: `http://localhost/ijinkeluar`
   - Database SQLite akan dibuat otomatis saat pertama kali diakses

### Login Default

**Administrator:**
- NIP: `admin`
- Password: `admin123`

**User Demo:**
- NIP: `198203012005011001`
- Password: `123456`

### Struktur Database

**Tabel Users**
- id, nip, name, email, password, role, position, department, phone, is_active

**Tabel Permissions**
- id, user_id, permission_type_id, request_date, start_time, end_time, purpose, destination, status, approved_by, approved_at

**Tabel Permission_Types**
- id, name, description, is_active

**Tabel Settings**
- id, setting_key, setting_value, description

### Konfigurasi

File konfigurasi utama berada di `config/config.php`. Anda dapat mengubah:

- Database path
- Upload file settings
- Security settings
- Application constants

### Fitur Keamanan

- CSRF Protection
- Input sanitization
- Password hashing (bcrypt)
- File upload validation
- Session management
- SQL injection prevention (PDO)

### Penggunaan

1. **Login**: Gunakan NIP dan password untuk masuk
2. **Dashboard**: Lihat statistik dan pengajuan terbaru
3. **Pengajuan Baru**: Klik "Pengajuan Izin" di sidebar
4. **Riwayat**: Lihat semua pengajuan di menu "Riwayat Izin"
5. **Persetujuan**: Admin dapat menyetujui/menolak pengajuan

### Struktur File

```
ijinkeluar/
├── config/
│   ├── config.php          # Konfigurasi utama
│   ├── database.php        # Kelas database SQLite
│   └── auth.php           # Sistem autentikasi
├── includes/
│   ├── functions.php      # Fungsi CRUD permissions
│   ├── header.php         # Header komponen
│   └── sidebar.php        # Sidebar komponen
├── database/
│   └── siskim.db          # Database SQLite (auto-created)
├── uploads/               # Folder upload file
├── dashboard.php          # Halaman utama setelah login
├── login.php              # Halaman login
├── pengajuan.php          # Form pengajuan izin
├── riwayat.php            # Daftar riwayat izin
├── logout.php             # Logout handler
├── delete_permission.php  # Handler hapus pengajuan
├── index.php              # Redirect utama
└── .htaccess              # Apache configuration
```

### Development

Untuk development, aktifkan error reporting di `config/config.php`:
```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

### Production

Untuk production:
1. Set `display_errors` ke 0
2. Aktifkan HTTPS
3. Ubah password default
4. Backup database secara berkala
5. Set proper file permissions

### Troubleshooting

**Database Error:**
- Pastikan folder `database/` writable (chmod 777)
- Cek PHP extension PDO dan PDO_SQLite

**File Upload Error:**
- Pastikan folder `uploads/` writable
- Cek PHP settings: `upload_max_filesize`, `post_max_size`

**Login Issues:**
- Cek database connection
- Pastikan password sudah di-hash dengan benar

### Support

Untuk pertanyaan atau masalah, silakan hubungi tim IT Pengadilan Negeri Watampone.

---
© 2023 Pengadilan Negeri Watampone. All rights reserved.